% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grey.zones.R
\name{grey.zones}
\alias{grey.zones}
\title{Plot boxes to indicate areas of low sample size.}
\usage{
grey.zones(boxes, colours, opacity, ylim = 0)
}
\arguments{
\item{boxes}{A list resembling the third element of the output from a cpue call ("small.n").}

\item{colours}{Character vector: colours to be used for boxes at each level of small sample. No default.}

\item{opacity}{Numeric vector: opacity of boxes at each level of small sample. No default}

\item{ylim}{Numeric: an easy way to override the built-in scaling in plot - if a vector of length 1 is passed it will
be converted into c(0, ylim) to be passed to the ylim argument in plot. Alternatively a vector of length 2 will be passed
straight to plot as is. Defaults to NULL, in which case the built-in scaling in plot takes over.}
}
\value{
None.
}
\description{
A utility function sometimes called by main archSeries plotting functions when dealing with output from cpue. Can in theory also be used
     alone after a call to axis.setup.
}
\examples{
dates <- data.table(Start=c(450, 450, 600), End=c(700, 800, 650), frags=c(3,6,2), vol=c(40, 40, 40))
x <- cpue(dates, dates, dates$frags, dates$vol, context.fields=NULL, small.n=1, reps=1000)
axis.setup(x)
grey.zones(x$small.n, "grey30", 200, ylim=130)
}

